## read in toothbrush epg
cat('Reading Toothbrush data\n\n')
epg<-read.csv("toothbrush-anon.csv",sep = ",", header = TRUE,stringsAsFactors=FALSE)
epg$marker<-as.character(epg$marker)
epg$allele<-as.numeric(epg$allele)

##Starting parameters for MLE
rho<-5
eta <- sum(epg$height)/(length(epg$height))/rho
startpar <- mixpar(rho=list(rho),
                   eta = list(eta),
                   xi = list(0.1),
                   phi = list(c(U1 = .6, U2 = .4)))

# select markers to be included in the mixture model
mixmarkers<-NULL #selects all markers

if(!is.null(mixmarkers)) epg<-epg[!is.na(match(epg$marker,mixmarkers)),]
cat('markers used in mixture:',unique(sort(epg$marker)),fill=60)

####mixture of two unknown  contributors####
mixD<-DNAmixture(list(epg), k = 2, C = rep(list(C), length(list(epg))), 
                 database = db) 

pars<-mixpar(rho=list(8.964183),
	eta = list(265.6162),
	xi = list(0),
	phi = list(c(U1 = 0.92644211, U2 = 0.07355789)))

cat('\nParameters set to\n')
print(pars)

mu<-pars[[1]]*pars[[2]]
sigma<-1/sqrt(pars[[2]])
cat('mu', mu,'\nsigma', sigma,'\n')

baseline<-logL(mixD)(pars)
cat('\nvanilla model log likelihood:',baseline,'\n')

